<?php

namespace App\Models;

use CodeIgniter\Model;

class DocsModel extends Model
{
    protected $table            = 'tally__docs';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = [ 'operator_id', 'term_num', 'num', 'title', 'debit', 'credit', 'rows', 'hidden_rows', 'type', 'status', 'section'];

    protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'int';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'operator_id' => 'required',
        'num' => 'required|max_length[4]',
        'term' => 'required|max_length[3]|greater_than[401]|less_than[421]',
        'term_num' => "required|max_length[7]|min_length[6]|is_unique[tally__docs.term_num]",
	'title' => 'required',
	'created_at' => 'required'
    ];
    protected $validationMessages = [
        'term' => [
            'required'=>'وارد کردن سال مالي اجباري است',
            'max_length'=>'سال مالي خارج از حد مجاز است',
	    'greater_than' => 'سال مالي کمتراز حد مجاز است',
	    'less_than' => 'سال مالي بيشتر حد مجاز است'
        ],
	'term_num' =>[
	    'required' => 'کليد پارتيشن وارد نشده',
	    'max_length' => 'طول کليد پارتيشن بيشتر از حد مجاز است',
	    'min_length' => 'طول کليد پارتيشن کمتر از حد مجاز است',
	    'is_unique' => 'شماره سند تکراري است'
	],
	'operator_id' => [
	    'required' => 'لطفا وارد شويد',
	],
	'num' => [
	    'required' => 'شماره سند وارد نشده',
	    'max_length' => 'شماره سند بيشتر از حد مجاز است',
	],
	'title' => [
	    'required' => 'عنوان را وارد کنيد'
	],
	'created_at' =>[
	    'required' => 'تاريخ را وارد کنيد'
	]
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
    
    
}