<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\FilesModel;

class UploadControllers extends BaseController
{
    public function index()
    {
        //
    }
    
    public function upload() {
	$fileModel = new FilesModel();
	$rowModel = new \App\Models\RowsModel();
        $exel = $this->request->getFile('file');
        $doc_num = $this->request->getVar('doc');
	$last_doc_row = $rowModel->select('row_num')->where(['doc_num'=>$doc_num])->orderBy('row_num', 'DESC')->first();
	$exel->move('upload/', $exel->getClientName(), true);
	$name = $exel->getClientName();
	$data = [ 'title' => $name, 'path' => 'upload/' ];	
	$reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader('Xlsx');
	$reader->setReadDataOnly(TRUE);
	$spreadsheet = $reader->load($data['path'].$data['title']);
	
	$worksheet = $spreadsheet->getActiveSheet();
	$highestRow = $worksheet->getHighestDataRow();
	$highcloumn = $worksheet->getHighestColumn();
	if(empty($last_doc_row)){ $rowCounter=1; } else { $rowCounter = $last_doc_row->row_num; }
	if($highcloumn == 'AC'){  $this->setBuyExel($worksheet, $highestRow, $doc_num, $rowCounter); }
	if($highcloumn == 'T'){  $this->setTransferExel($worksheet, $highestRow, $doc_num, $rowCounter); }
    }
    
    public function setBuyExel($worksheet, $highestRow, $doc_num, $rowCounter) {
	$rowModel = new \App\Models\RowsModel();
	$detailModel = new \App\Models\DetailesModel();
	for ($row = 2; $row <= $highestRow; ++$row) {
	    $nation = $worksheet->getCell([5, $row])->getValue();
	    if(empty($nation)){ $rowCounter++;	continue; }
	    $dbDetail = $detailModel->select()->where('nation', $nation)->first();
	    if(empty($dbDetail)){
		$last_detail = $detailModel->select()->orderBy('coding', 'DESC')->first();
		$detail = [
		    'coding' => (empty($last_detail))?30001:$last_detail->coding+1,
		    'nation' => $worksheet->getCell([5, $row])->getValue(),
		    'title' => $worksheet->getCell([6, $row])->getValue(),
		    'address' => $worksheet->getCell([28, $row])->getValue(),
		    'type' => 1
		];
		$detailModel->save($detail);
	    }
	    $rowdata = [
		'operator_id' => 223,
		'doc_num' => intval($doc_num),
		'row_num' => $rowCounter,
		'part_index' => '402'.sprintf('%04d',$doc_num).sprintf('%03d', $rowCounter),
		'factor_num' => $worksheet->getCell([9, $row])->getValue(),
		'parent_coding' => '2305', 
		'parent_title' => 'حسابهای دریافتنی تجاری - اشخاص حقیقی',
		'coding' => $worksheet->getCell([4, $row])->getValue(),
		'coding_title' => $worksheet->getCell([6, $row])->getValue(),
		'description' => 'خريد از طريق بانک سپه',
		'debit' => 0,
		'credit' =>  $worksheet->getCell([23, $row])->getValue(),
		'amount' => $worksheet->getCell([19, $row])->getValue(),
		'fi' => $worksheet->getCell([14, $row])->getValue(),
		'status' => 0,
		'section' => 0,
		'created_at' => time()
	    ];
	    $rowModel->save($rowdata); $rowCounter++;
	}
    }
    
    public function setTransferExel($worksheet, $highestRow, $doc_num, $rowCounter) {
	$rowModel = new \App\Models\RowsModel();
	for ($row = 5; $row <= $highestRow; ++$row) {
	    $rowdata = [
		'operator_id' => 223,
		'doc_num' => intval($doc_num),
		'row_num' => $rowCounter,
		'part_index' => '402'.sprintf('%04d',$doc_num).sprintf('%03d', $rowCounter),
		'factor_num' => $worksheet->getCell([9, $row])->getValue(),
		'parent_coding' => '2601', 
		'parent_title' => 'موجودي نزد بانک ريالي',
		'coding' => 10000,
		'coding_title' => 'بانک سپه 47304097002',
		'description' => 'بابت انتقال وجه مستند به پرينت بانک',
		'debit' => 0,
		'credit' =>  str_replace(',', '', $worksheet->getCell([13, $row])->getValue()),
		'amount' => 0,
		'fi' => 0,
		'status' => 0,
		'section' => 0,
		'created_at' => time()
	    ];
	    $rowModel->save($rowdata); $rowCounter++;
	}
    }
}
