<?php

namespace App\Controllers;

use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\RESTful\ResourceController;
use App\Models\DocsModel;
use App\Models\RowsModel;

class DocsController extends ResourceController
{
    public function index()
    {
        $model = new DocsModel();
	$data = [
	    'title' => 'اسناد',
	    'jdate' => new \App\Libraries\JDate(),
	    'rows' => $model->orderBy('id', 'DESC')->findAll()
	];
        echo view('docs/main', $data);
    }

    public function show($doc_num = null)
    {
        //return $this->respond($data);
	//if(!$data) { return $this->failNotFound('No Data Found'); }
        $model = new RowsModel();
	$doc_model = new DocsModel();
        $data = [
	    'title' => ' سند شماره: '.$doc_num,
	    'doc' => $doc_model->where('num', $doc_num)->first(),
	    'jdate' => new \App\Libraries\JDate(),
	    'rows' => $model->where('doc_num', $doc_num)->findAll(),
	];
	echo view('rows/main', $data);
    }

    public function new()
    {
        echo 'new';
    }

    public function create()
    {
        $model = new DocsModel();
	$jdate = new \App\Libraries\JDate();
	$last_doc = $model->select(['num'])->orderBy('num', 'DESC')->first();
	$data = [
	    'operator_id' => 1,
	    'term' => 402,
	    'num' => (empty($last_doc))?1:$last_doc->num+1,
	    'title' => $this->request->getVar('title'),
	    'type' => $this->request->getVar('type'),
	    'created_at' => $jdate->jstrtotime($this->request->getVar('created_at'))
	];
	$data['term_num'] = implode([sprintf('%03d',$data['term']), sprintf('%04d',$data['num'])]);
        $model->save($data);
	if(empty($model->errors())){
	    $response = [
		'status' => 201,
		'messages' => [
		    'success' => 'سند ثبت شد',
		    'row' => view('docs/table', [
			'row'=>$model->find($model->getInsertID()),
			'jdate'=> new \App\Libraries\JDate()
		    ])
		]
	    ];
	    return $this->respondCreated($response);
	} else {
	    return $this->failValidationErrors($model->errors());
	}
    }

    public function edit($id = null)
    {
        echo 'edit';
    }

    public function update($id = null)
    {
	echo 'updated';
        helper(['form']);
        $rules = [
            'title' => 'required',
            'price' => 'required'
        ];
        $data = [
            'title' => $this->request->getVar('title'),
            'price' => $this->request->getVar('price')
        ];
	if(!$this->validate($rules)) {return $this->fail($this->validator->getErrors());}
        $model = new DocsModel();
        $findById = $model->find(['id' => $id]);
	if(!$findById) {return $this->failNotFound('No Data Found');}
        $model->update($id, $data);
        $response = [
            'status' => 200,
            'error' => null,
            'messages' => [
                'success' => 'Data Updated'
            ]
        ];
        return $this->respond($response);
    }

    public function delete($id = null)
    {
        echo $id;
    }
}
