<?php

namespace App\Controllers;

use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\RESTful\ResourceController;

class DetailesController extends ResourceController
{

    
    public function index()
    {
        $detailModel = new \App\Models\DetailesModel();
        $data = [
            'title' => 'حسابهاي تفصيلي',
            'jdate' => new \App\Libraries\JDate(),
            'detailes' => $detailModel->orderBy('coding')->findAll(),
                'last_detail' => $detailModel->select()->orderBy('coding', 'DESC')->first(),
        ];
        echo view('detailes/main', $data);
    }

    public function show($id = null)
    {
        //
    }

    
    public function new()
    {
        //
    }

    
    public function create()
    {
        $model = new \App\Models\DetailesModel();
        $jdate = new \App\Libraries\JDate();
        $type = $this->request->getVar('type');
        
        
        $data = [
            'type' => $type,
            'coding' => $this->request->getVar('coding'),
            'title' => $this->request->getVar('title'),
            'nation' => $this->request->getVar('nation'),
            'mobile' => $this->request->getVar('mobile'),
        ];
        $model->save($data);
	if(empty($model->errors())){
	    $response = [
		'status' => 201,
		'messages' => [
		    'success' => 'سند ثبت شد',
		    'row' => view('detailes/table', [
			'row'=>$model->find($model->getInsertID()),
			'jdate'=> new \App\Libraries\JDate()
		    ])
		]
	    ];
	    return $this->respondCreated($response);
	} else {
	    return $this->failValidationErrors($model->errors());
	}
    }

    
    public function edit($id = null)
    {
        //
    }

    
    public function update($id = null)
    {
        //
    }

    
    public function delete($id = null)
    {
        //
    }
    
    public function search($val){
        $codingModel = new \App\Models\DetailesModel();
        $result = $codingModel->select()->like('coding', $val)->orLike('title', $val)->findAll();
        echo view('/detailes/getDetailes', ['coding'=>$result, 'functionName'=>'getDetailesFromResult(this)']);
    }
    public function searchUser($val){
        $codingModel = new \App\Models\DetailesModel();
        $result = $codingModel->select()
            ->where('type', 'pe')
            ->groupStart()
                ->like('coding', $val)
                ->orLike('title', $val)
                ->orLike('nation', $val)
            ->groupEnd()
            ->findAll();
        echo view('/detailes/getDetailes', ['coding'=>$result, 'functionName'=>'getUserFromResult(this)']);
    }
    public function searchStuff($val){
        $codingModel = new \App\Models\DetailesModel();
        $result = $codingModel->select()
            ->where('type', 'st')
            ->groupStart()
                ->like('coding', $val)
                ->orLike('title', $val)
                ->orLike('nation', $val)
            ->groupEnd()
            ->findAll();
        echo view('/detailes/getDetailes', ['coding'=>$result, 'functionName'=>'getStuffFromResult(this)']);
    }
}
